/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import oracle.install.commons.util.ProxyFactory;

public class IconLibrary {
    private static final Logger logger = Logger.getLogger(IconLibrary.class.getName());
    private Map<Object, ImageIcon> iconCache = Collections.synchronizedMap(new WeakHashMap());
    private static IconLibrary instance = null;

    public static IconLibrary getInstance() {
        if (instance == null) {
            ProxyFactory proxyFactory = ProxyFactory.getInstance();
            instance = proxyFactory.createProxy(IconLibrary.class, new IconLibrary());
        }
        return instance;
    }

    public ImageIcon getIcon(File file) {
        ImageIcon icon = null;
        if (file != null && (icon = this.iconCache.get(file)) == null && file.isFile() && file.exists()) {
            try {
                icon = new ImageIcon(file.toURL());
                this.iconCache.put(file, icon);
            }
            catch (MalformedURLException e) {
                logger.warning(e.getMessage());
            }
        }
        return icon;
    }

    public ImageIcon getIcon(URL url) {
        ImageIcon icon = null;
        if (url != null && (icon = this.iconCache.get(url)) == null) {
            icon = new ImageIcon(url);
            this.iconCache.put(url, icon);
        }
        return icon;
    }

    public ImageIcon getIcon(String path) {
        ImageIcon icon = null;
        if (path != null && (icon = this.iconCache.get(path)) == null) {
            try {
                URL iconURL = IconLibrary.class.getResource(path);
                icon = this.getIcon(iconURL);
                this.iconCache.put(path, icon);
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
            }
        }
        return icon;
    }

    public void clearCache() {
        this.iconCache.clear();
    }
}

